/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.acquiring.sdk.utils;

import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.util.Arrays;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import ru.tinkoff.acquiring.sdk.utils.Base64;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u0016\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\nJ\u0010\u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\u0004H\u0002J\n\u0010\r\u001a\u00020\u0004*\u00020\u0004\u00a8\u0006\u000e"}, d2={"Lru/tinkoff/acquiring/sdk/utils/CryptoUtils;", "", "()V", "encodeBase64", "", "value", "", "encryptRsa", "string", "publicKey", "Ljava/security/PublicKey;", "hashString", "input", "sha256", "core"})
public final class CryptoUtils {
    @NotNull
    public static final CryptoUtils INSTANCE = new CryptoUtils();

    private CryptoUtils() {
    }

    @NotNull
    public final byte[] encryptRsa(@NotNull String string, @NotNull PublicKey publicKey) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"string");
        Intrinsics.checkNotNullParameter((Object)publicKey, (String)"publicKey");
        try {
            Cipher cipher = Cipher.getInstance("RSA/ECB/PKCS1Padding");
            cipher.init(1, publicKey);
            String string2 = string;
            byte[] byArray = string2.getBytes(Charsets.UTF_8);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
            byte[] byArray2 = cipher.doFinal(byArray);
            Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"cipher.doFinal(string.toByteArray())");
            return byArray2;
        }
        catch (NoSuchPaddingException e) {
            throw new RuntimeException(e);
        }
        catch (InvalidKeyException e) {
            throw new RuntimeException(e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        catch (BadPaddingException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalBlockSizeException e) {
            throw new RuntimeException(e);
        }
    }

    @NotNull
    public final String encodeBase64(@NotNull byte[] value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        String string = Base64.encodeToString(value, 0);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"encodeToString(value, Base64.DEFAULT)");
        return ((Object)StringsKt.trim((CharSequence)string)).toString();
    }

    @NotNull
    public final String sha256(@NotNull String $this$sha256) {
        Intrinsics.checkNotNullParameter((Object)$this$sha256, (String)"<this>");
        return this.hashString($this$sha256);
    }

    /*
     * WARNING - void declaration
     */
    private final String hashString(String input) {
        void $this$fold$iv;
        MessageDigest messageDigest = MessageDigest.getInstance("SHA-256");
        String string = input;
        byte[] byArray = string.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
        byte[] byArray2 = messageDigest.digest(byArray);
        Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"getInstance(\"SHA-256\")\n \u2026gest(input.toByteArray())");
        String initial$iv = "";
        boolean $i$f$fold = false;
        String accumulator$iv = initial$iv;
        int n = ((void)$this$fold$iv).length;
        for (int i = 0; i < n; ++i) {
            void it;
            void element$iv;
            void var9_9 = element$iv = $this$fold$iv[i];
            String str = accumulator$iv;
            boolean bl = false;
            Object[] objectArray = new Object[]{(byte)it};
            String string2 = String.format("%02x", Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(this, *args)");
            accumulator$iv = Intrinsics.stringPlus((String)str, (Object)string2);
        }
        return accumulator$iv;
    }
}

