/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.acquiring.sdk.models.paysources;

import java.security.PublicKey;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import ru.tinkoff.acquiring.sdk.models.paysources.CardSource;
import ru.tinkoff.acquiring.sdk.utils.CardValidator;
import ru.tinkoff.acquiring.sdk.utils.CryptoUtils;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0010\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0006B\u0005\u00a2\u0006\u0002\u0010\u0007J\r\u0010\u0010\u001a\u00020\u0003H\u0000\u00a2\u0006\u0002\b\u0011J\u0010\u0010\u0012\u001a\u00020\u00032\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\b\u0010\u0015\u001a\u00020\u0016H\u0016R\u001a\u0010\u0004\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\t\"\u0004\b\r\u0010\u000bR\u001a\u0010\u0005\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\t\"\u0004\b\u000f\u0010\u000b\u00a8\u0006\u0017"}, d2={"Lru/tinkoff/acquiring/sdk/models/paysources/CardData;", "Lru/tinkoff/acquiring/sdk/models/paysources/CardSource;", "pan", "", "expiryDate", "securityCode", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "()V", "getExpiryDate", "()Ljava/lang/String;", "setExpiryDate", "(Ljava/lang/String;)V", "getPan", "setPan", "getSecurityCode", "setSecurityCode", "buildStringForEncoding", "buildStringForEncoding$core", "encode", "publicKey", "Ljava/security/PublicKey;", "validate", "", "core"})
@SourceDebugExtension(value={"SMAP\nCardData.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CardData.kt\nru/tinkoff/acquiring/sdk/models/paysources/CardData\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,78:1\n1#2:79\n*E\n"})
public final class CardData
implements CardSource {
    @NotNull
    private String pan;
    @NotNull
    private String expiryDate;
    @NotNull
    private String securityCode;

    public CardData() {
        this.pan = "";
        this.expiryDate = "";
        this.securityCode = "";
    }

    @NotNull
    public final String getPan() {
        return this.pan;
    }

    public final void setPan(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.pan = string;
    }

    @NotNull
    public final String getExpiryDate() {
        return this.expiryDate;
    }

    public final void setExpiryDate(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.expiryDate = string;
    }

    @NotNull
    public final String getSecurityCode() {
        return this.securityCode;
    }

    public final void setSecurityCode(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.securityCode = string;
    }

    public CardData(@NotNull String pan, @NotNull String expiryDate, @NotNull String securityCode) {
        Intrinsics.checkNotNullParameter((Object)pan, (String)"pan");
        Intrinsics.checkNotNullParameter((Object)expiryDate, (String)"expiryDate");
        Intrinsics.checkNotNullParameter((Object)securityCode, (String)"securityCode");
        this();
        this.pan = pan;
        this.expiryDate = expiryDate;
        this.securityCode = securityCode;
    }

    @Override
    @NotNull
    public String encode(@NotNull PublicKey publicKey) {
        Intrinsics.checkNotNullParameter((Object)publicKey, (String)"publicKey");
        this.validate();
        String data = this.buildStringForEncoding$core();
        return CryptoUtils.INSTANCE.encodeBase64(CryptoUtils.INSTANCE.encryptRsa(data, publicKey));
    }

    @NotNull
    public final String buildStringForEncoding$core() {
        CharSequence charSequence = this.expiryDate;
        Regex regex = new Regex("\\D");
        String string = "";
        String date = regex.replace(charSequence, string);
        return "PAN=" + this.pan + ";ExpDate=" + date + ";CVV=" + this.securityCode;
    }

    @Override
    public void validate() {
        String wrongField = null;
        if (!CardValidator.INSTANCE.validateNumber(this.pan)) {
            wrongField = "number";
        } else if (!CardValidator.INSTANCE.validateExpirationDate(this.expiryDate)) {
            wrongField = "expiration date";
        }
        if (!CardValidator.INSTANCE.validateSecurityCode(this.securityCode) && wrongField == null) {
            wrongField = "security code";
        }
        if (!(wrongField == null)) {
            boolean bl = false;
            String string = "Cannot encode card data. Wrong " + wrongField;
            throw new IllegalStateException(string.toString());
        }
    }
}

