/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.acquiring.sdk.utils.keycreators;

import java.security.KeyFactory;
import java.security.PublicKey;
import java.security.spec.X509EncodedKeySpec;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import ru.tinkoff.acquiring.sdk.exceptions.AcquiringSdkException;
import ru.tinkoff.acquiring.sdk.utils.Base64;
import ru.tinkoff.acquiring.sdk.utils.keycreators.KeyCreator;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lru/tinkoff/acquiring/sdk/utils/keycreators/StringKeyCreator;", "Lru/tinkoff/acquiring/sdk/utils/keycreators/KeyCreator;", "source", "", "(Ljava/lang/String;)V", "create", "Ljava/security/PublicKey;", "core"})
public final class StringKeyCreator
implements KeyCreator {
    @NotNull
    private final String source;

    public StringKeyCreator(@NotNull String source) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        this.source = source;
    }

    @Override
    @NotNull
    public PublicKey create() {
        try {
            byte[] publicBytes = Base64.decode(this.source, 0);
            X509EncodedKeySpec keySpec = new X509EncodedKeySpec(publicBytes);
            KeyFactory keyFactory = KeyFactory.getInstance("RSA");
            PublicKey publicKey = keyFactory.generatePublic(keySpec);
            Intrinsics.checkNotNullExpressionValue((Object)publicKey, (String)"generatePublic(...)");
            return publicKey;
        }
        catch (Exception e) {
            throw new AcquiringSdkException(e, null, null, 6, null);
        }
    }
}

