/*
 * Copyright © 2020 Tinkoff Bank
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

package ru.tinkoff.acquiring.sdk.exceptions

import ru.tinkoff.acquiring.sdk.network.AcquiringApi
import ru.tinkoff.acquiring.sdk.responses.AcquiringResponse

class AcquiringApiException : Exception, AcquiringExceptionWithErrorCode {

    var response: AcquiringResponse? = null
        set(value) {
            field = value
            errorCode = value?.errorCode
        }
    override var errorCode: String? = null

    constructor(response: AcquiringResponse, message: String) : super(message) {
        this.response = response
    }

    constructor(response: AcquiringResponse) : super("") {
        this.response = response
    }
}

fun Exception.checkCustomerNotFoundError(): Boolean {
    return getErrorCodeIfApiError() == AcquiringApi.API_ERROR_CODE_CUSTOMER_NOT_FOUND
}

fun Throwable.getErrorCodeIfApiError(): String? = when (this) {
    is AcquiringApiException -> {
        this.response?.errorCode
    }

    is AcquiringSdkException -> {
        this.errorCode
    }

    else -> {
        null
    }
}

fun Throwable.getPaymentIdIfSdkError(): Long? = when (this) {
    is AcquiringSdkException -> {
        this.paymentId
    }

    else -> {
        null
    }
}
