package ru.tinkoff.acquiring.sdk.models.enums

/**
 * Тип документа
 *
 * @author Michael Babayan
 */
enum class DocumentType(val code: Int) {
    /**
     * Паспорт гражданина Российской Федерации
     */
    PASSPORT_RF(21),

    /**
     * Паспорт гражданина Российской Федерации, дипломатический паспорт, служебный паспорт
     */
    DIPLOMATIC_PASSPORT_RF(22),

    /**
     * Временное удостоверение личности гражданина Российской Федерации
     */
    TEMP_ID_RF(26),

    /**
     * Свидетельство о рождении гражданина Российской Федерации (для граждан Российской Федерации в возрасте до 14 лет)
     */
    BIRTH_CERTIFICATE_RF(27),

    /**
     * Иные документы, признаваемые документами, удостоверяющими личность гражданина Российской Федерации
     */
    OTHER_RF_DOCUMENTS(28),

    /**
     * Паспорт иностранного гражданина
     */
    FOREIGN_PASSPORT(31),

    /**
     * Иные документы, признаваемые документами, удостоверяющими личность иностранного гражданина
     */
    OTHER_FOREIGN_DOCUMENTS(32),

    /**
     * Документ, выданный иностранным государством и признаваемый в соответствии с международным договором Российской Федерации
     */
    FOREIGN_STATE_DOCUMENT(33),

    /**
     * Вид на жительство (для лиц без гражданства)
     */
    RESIDENCE_PERMIT(34),

    /**
     * Разрешение на временное проживание (для лиц без гражданства)
     */
    TEMP_RESIDENCE_PERMIT(35),

    /**
     * Свидетельство о рассмотрении ходатайства о признании лица без гражданства беженцем на территории Российской Федерации
     */
    REFUGEE_APPLICATION_CERTIFICATE(36),

    /**
     * Удостоверение беженца
     */
    REFUGEE_ID(37),

    /**
     * Иные документы, признаваемые документами, удостоверяющими личность лиц без гражданства
     */
    OTHER_STATELESS_PERSON_DOCUMENTS(38),

    /**
     * Документ, удостоверяющий личность лица, не имеющего действительного документа, удостоверяющего личность, на период рассмотрения заявления о признании гражданином Российской Федерации или о приеме в гражданство Российской Федерации
     */
    TEMP_CITIZENSHIP_ID(40)
}
