package ru.tinkoff.acquiring.sdk.models.enums

/**
 * Код товара, формат которого не идентифицирован, как один из реквизитов
 *
 * @author Michael Babayan
 */
enum class MarkCodeType {
    /**
     * Код товара, формат которого не идентифицирован, как один из реквизитов.
     */
    UNKNOWN,

    /**
     * Код товара в формате EAN-8.
     */
    EAN8,

    /**
     * Код товара в формате EAN-13.
     */
    EAN13,

    /**
     * Код товара в формате ITF-14.
     */
    ITF14,

    /**
     * Код товара в формате GS1, нанесенный на товар, не подлежащий маркировке средствами идентификации.
     */
    GS10,

    /**
     * Код товара в формате GS1, нанесенный на товар, подлежащий маркировке средствами идентификации.
     */
    GS1M,

    /**
     * Код товара в формате короткого кода маркировки, нанесенный на товар, подлежащий маркировке средствами идентификации.
     */
    SHORT,

    /**
     * Контрольно-идентификационный знак мехового изделия.
     */
    FUR,

    /**
     * Код товара в формате ЕГАИС-2.0.
     */
    EGAIS20,

    /**
     * Код товара в формате ЕГАИС-3.0.
     */
    EGAIS30
}
