/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.acquiring.sdk.network;

import com.google.gson.ExclusionStrategy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.IOException;
import java.lang.reflect.Type;
import java.net.MalformedURLException;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLException;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import okhttp3.Call;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import ru.tinkoff.acquiring.sdk.AcquiringSdk;
import ru.tinkoff.acquiring.sdk.exceptions.AcquiringApiException;
import ru.tinkoff.acquiring.sdk.exceptions.AcquiringException;
import ru.tinkoff.acquiring.sdk.exceptions.AcquiringNetworkConnectException;
import ru.tinkoff.acquiring.sdk.exceptions.AcquiringNetworkError;
import ru.tinkoff.acquiring.sdk.exceptions.AcquiringNetworkException;
import ru.tinkoff.acquiring.sdk.exceptions.AcquiringNetworkSSLException;
import ru.tinkoff.acquiring.sdk.exceptions.AcquiringNetworkTimeoutException;
import ru.tinkoff.acquiring.sdk.exceptions.AcquiringSdkException;
import ru.tinkoff.acquiring.sdk.models.enums.CardStatus;
import ru.tinkoff.acquiring.sdk.models.enums.ResponseStatus;
import ru.tinkoff.acquiring.sdk.models.enums.Tax;
import ru.tinkoff.acquiring.sdk.models.enums.Taxation;
import ru.tinkoff.acquiring.sdk.network.AcquiringApi;
import ru.tinkoff.acquiring.sdk.requests.AcquiringRequest;
import ru.tinkoff.acquiring.sdk.requests.FinishAuthorizeRequest;
import ru.tinkoff.acquiring.sdk.responses.AcquiringResponse;
import ru.tinkoff.acquiring.sdk.responses.GetCardListResponse;
import ru.tinkoff.acquiring.sdk.utils.serialization.CardStatusSerializer;
import ru.tinkoff.acquiring.sdk.utils.serialization.CardsListDeserializer;
import ru.tinkoff.acquiring.sdk.utils.serialization.PaymentStatusSerializer;
import ru.tinkoff.acquiring.sdk.utils.serialization.SerializableExclusionStrategy;
import ru.tinkoff.acquiring.sdk.utils.serialization.TaxSerializer;
import ru.tinkoff.acquiring.sdk.utils.serialization.TaxationSerializer;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000 /2\u00020\u0001:\u0002/0B\u0005\u00a2\u0006\u0002\u0010\u0002J_\u0010\b\u001a\u00020\t\"\b\b\u0000\u0010\n*\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u0002H\n0\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u0002H\n0\u000f2\u0012\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u0002H\n\u0012\u0004\u0012\u00020\t0\u00112\u0016\u0010\u0012\u001a\u0012\u0012\b\u0012\u00060\u0013j\u0002`\u0014\u0012\u0004\u0012\u00020\t0\u0011H\u0000\u00a2\u0006\u0002\b\u0015J%\u0010\u0016\u001a\u00020\u0017\"\b\b\u0000\u0010\n*\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u0002H\n0\rH\u0000\u00a2\u0006\u0002\b\u0018JD\u0010\u0019\u001a\u00020\t\"\b\b\u0000\u0010\n*\u00020\u000b2\b\u0010\u001a\u001a\u0004\u0018\u0001H\n2!\u0010\u001b\u001a\u001d\u0012\u0013\u0012\u00110\u001c\u00a2\u0006\f\b\u001d\u0012\b\b\u001e\u0012\u0004\b\b(\u001f\u0012\u0004\u0012\u00020\t0\u0011H\u0002\u00a2\u0006\u0002\u0010 J\u0010\u0010!\u001a\u00020\u00062\u0006\u0010\"\u001a\u00020#H\u0002J\b\u0010$\u001a\u00020\u0006H\u0002J\b\u0010%\u001a\u00020#H\u0002J\u001c\u0010&\u001a\u00020'2\b\u0010(\u001a\u0004\u0018\u00010'2\b\u0010)\u001a\u0004\u0018\u00010'H\u0002J\u0012\u0010*\u001a\u00020+2\b\u0010,\u001a\u0004\u0018\u00010'H\u0002J\u0010\u0010-\u001a\u00020.*\u0006\u0012\u0002\b\u00030\rH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\u0001X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00061"}, d2={"Lru/tinkoff/acquiring/sdk/network/NetworkClient;", "", "()V", "gson", "Lcom/google/gson/Gson;", "okHttpClient", "Lokhttp3/OkHttpClient;", "okHttpClientSettings", "call", "", "R", "Lru/tinkoff/acquiring/sdk/responses/AcquiringResponse;", "request", "Lru/tinkoff/acquiring/sdk/requests/AcquiringRequest;", "responseClass", "Ljava/lang/Class;", "onSuccess", "Lkotlin/Function1;", "onFailure", "Ljava/lang/Exception;", "Lkotlin/Exception;", "call$core", "callRaw", "Lokhttp3/Response;", "callRaw$core", "checkResult", "result", "onChecked", "", "Lkotlin/ParameterName;", "name", "isSuccess", "(Lru/tinkoff/acquiring/sdk/responses/AcquiringResponse;Lkotlin/jvm/functions/Function1;)V", "createOkHttpClient", "settings", "Lru/tinkoff/acquiring/sdk/network/NetworkClient$OkHttpClientSettings;", "getOkHttpClient", "getOkHttpClientSettings", "makeNetworkErrorMessage", "", "message", "details", "prepareURL", "Ljava/net/URL;", "apiMethod", "httpRequest", "Lokhttp3/Request;", "Companion", "OkHttpClientSettings", "core"})
@SourceDebugExtension(value={"SMAP\nNetworkClient.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NetworkClient.kt\nru/tinkoff/acquiring/sdk/network/NetworkClient\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,270:1\n216#2,2:271\n*S KotlinDebug\n*F\n+ 1 NetworkClient.kt\nru/tinkoff/acquiring/sdk/network/NetworkClient\n*L\n172#1:271,2\n*E\n"})
public final class NetworkClient {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private OkHttpClient okHttpClient;
    @Nullable
    private Object okHttpClientSettings;
    @NotNull
    private final Gson gson = Companion.createGson();

    public final <R extends AcquiringResponse> void call$core(@NotNull AcquiringRequest<R> request, @NotNull Class<R> responseClass, @NotNull Function1<? super R, Unit> onSuccess, @NotNull Function1<? super Exception, Unit> onFailure) {
        block8: {
            Intrinsics.checkNotNullParameter(request, (String)"request");
            Intrinsics.checkNotNullParameter(responseClass, (String)"responseClass");
            Intrinsics.checkNotNullParameter(onSuccess, (String)"onSuccess");
            Intrinsics.checkNotNullParameter(onFailure, (String)"onFailure");
            String response = null;
            try {
                Response httpResponse = this.callRaw$core(request);
                int responseCode = httpResponse.code();
                ResponseBody responseBody = httpResponse.body();
                String string = response = responseBody != null ? responseBody.string() : null;
                if (responseCode == 200) {
                    AcquiringSdk.Companion.log("=== Got server response: " + response);
                    AcquiringResponse result = (AcquiringResponse)this.gson.fromJson(response, responseClass);
                    this.checkResult(result, (Function1<? super Boolean, Unit>)((Function1)new Function1<Boolean, Unit>(request, result, onFailure, onSuccess, this){
                        final /* synthetic */ AcquiringRequest<R> $request;
                        final /* synthetic */ R $result;
                        final /* synthetic */ Function1<Exception, Unit> $onFailure;
                        final /* synthetic */ Function1<R, Unit> $onSuccess;
                        final /* synthetic */ NetworkClient this$0;
                        {
                            this.$request = $request;
                            this.$result = $result;
                            this.$onFailure = $onFailure;
                            this.$onSuccess = $onSuccess;
                            this.this$0 = $receiver;
                            super(1);
                        }

                        /*
                         * WARNING - void declaration
                         */
                        public final void invoke(boolean isSuccess) {
                            if (!this.$request.isDisposed()) {
                                if (this.$result == null) {
                                    AcquiringSdk.Companion.log("=== Response is empty");
                                    this.$onFailure.invoke((Object)new AcquiringNetworkException("\u0421\u0435\u0440\u0432\u0435\u0440 \u0432\u0435\u0440\u043d\u0443\u043b \u043f\u0443\u0441\u0442\u043e\u0439 \u043e\u0442\u0432\u0435\u0442"));
                                } else if (isSuccess) {
                                    AcquiringSdk.Companion.log("=== Request done with success, sent for processing");
                                    this.$onSuccess.invoke(this.$result);
                                } else {
                                    void $this$invoke_u24lambda_u240;
                                    AcquiringSdk.Companion.log("=== Request done with fail");
                                    AcquiringApiException acquiringApiException = new AcquiringApiException((AcquiringResponse)this.$result, NetworkClient.access$makeNetworkErrorMessage(this.this$0, ((AcquiringResponse)this.$result).getMessage(), ((AcquiringResponse)this.$result).getDetails()));
                                    R r = this.$result;
                                    AcquiringApiException acquiringApiException2 = acquiringApiException;
                                    Function1<Exception, Unit> function1 = this.$onFailure;
                                    boolean bl = false;
                                    $this$invoke_u24lambda_u240.setErrorCode(((AcquiringResponse)r).getErrorCode());
                                    function1.invoke((Object)acquiringApiException);
                                }
                            }
                        }
                    }));
                } else {
                    CharSequence charSequence = response;
                    if (!(charSequence == null || charSequence.length() == 0)) {
                        AcquiringSdk.Companion.log("=== Got server error response: " + response);
                    } else {
                        AcquiringSdk.Companion.log("=== Got server error response code: " + responseCode);
                    }
                    if (!request.isDisposed()) {
                        onFailure.invoke((Object)new AcquiringNetworkError(responseCode, "Unable to performRequest request " + request.getApiMethod$core()));
                    }
                }
            }
            catch (Exception e) {
                AcquiringSdk.Companion.log(e);
                if (request.isDisposed()) break block8;
                if (e instanceof AcquiringException) {
                    onFailure.invoke((Object)e);
                }
                onFailure.invoke((Object)new AcquiringSdkException(e, null, null, 6, null));
            }
        }
    }

    @NotNull
    public final <R extends AcquiringResponse> Response callRaw$core(@NotNull AcquiringRequest<R> request) {
        Response response;
        Intrinsics.checkNotNullParameter(request, (String)"request");
        try {
            Request httpRequest = this.httpRequest(request);
            Call call2 = this.getOkHttpClient().newCall(httpRequest);
            AcquiringSdk.Companion.log("=== Sending " + httpRequest.method() + " request to " + httpRequest.url());
            response = call2.execute();
        }
        catch (IOException e) {
            AcquiringSdk.Companion.log("=== Receive error " + e.getMessage() + " on method " + request.getHttpRequestMethod() + " " + request.getApiMethod$core());
            AcquiringSdk.Companion.log(e);
            String message = "Unable to performRequest request " + request.getApiMethod$core();
            IOException iOException = e;
            if (iOException instanceof SocketException ? true : iOException instanceof UnknownHostException) {
                throw new AcquiringNetworkConnectException(message, e);
            }
            if (iOException instanceof SocketTimeoutException) {
                throw new AcquiringNetworkTimeoutException(message, e);
            }
            if (iOException instanceof SSLException) {
                throw new AcquiringNetworkSSLException(message, e);
            }
            throw new AcquiringNetworkException(message, e);
        }
        return response;
    }

    private final Request httpRequest(AcquiringRequest<?> $this$httpRequest) {
        Request.Builder builder;
        Request.Builder builder2 = builder = new Request.Builder();
        boolean bl = false;
        builder2.url(this.prepareURL($this$httpRequest.getApiMethod$core()));
        String string = $this$httpRequest.getHttpRequestMethod();
        if (Intrinsics.areEqual((Object)string, (Object)"GET")) {
            builder2.get();
        } else if (Intrinsics.areEqual((Object)string, (Object)"POST")) {
            String body = $this$httpRequest.getRequestBody();
            AcquiringSdk.Companion.log("=== Parameters: " + body);
            builder2.post(RequestBody.Companion.create(body, MediaType.Companion.get($this$httpRequest.getContentType())));
        }
        if ($this$httpRequest instanceof FinishAuthorizeRequest && ((FinishAuthorizeRequest)$this$httpRequest).is3DsVersionV2()) {
            String string2 = System.getProperty("http.agent");
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getProperty(...)");
            builder2.header("User-Agent", string2);
            builder2.header("Accept", "application/json");
        }
        Map $this$forEach$iv = $this$httpRequest.getHeaders$core();
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry element$iv;
            Map.Entry entry = element$iv = iterator.next();
            boolean bl2 = false;
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            builder2.header(key, value);
        }
        return builder.build();
    }

    private final <R extends AcquiringResponse> void checkResult(R result, Function1<? super Boolean, Unit> onChecked) {
        if (result == null) {
            onChecked.invoke((Object)false);
        } else if (Intrinsics.areEqual((Object)result.getErrorCode(), (Object)"0") && Intrinsics.areEqual((Object)result.isSuccess(), (Object)true)) {
            onChecked.invoke((Object)true);
        } else {
            onChecked.invoke((Object)false);
        }
    }

    private final URL prepareURL(String apiMethod) throws MalformedURLException {
        CharSequence charSequence = apiMethod;
        if (charSequence == null || charSequence.length() == 0) {
            throw new IllegalArgumentException("Cannot prepare URL for request api method is empty or null!");
        }
        StringBuilder builder = new StringBuilder(AcquiringApi.INSTANCE.getUrl());
        builder.append("/");
        builder.append(apiMethod);
        return new URL(builder.toString());
    }

    private final String makeNetworkErrorMessage(String message, String details) {
        Object[] objectArray = new String[]{message, details};
        return CollectionsKt.joinToString$default((Iterable)CollectionsKt.filterNotNull((Iterable)SetsKt.setOf((Object[])objectArray)), (CharSequence)" ", null, null, (int)0, null, null, (int)62, null);
    }

    /*
     * WARNING - void declaration
     */
    private final OkHttpClient getOkHttpClient() {
        OkHttpClient okHttpClient;
        OkHttpClient currentClient = this.okHttpClient;
        OkHttpClientSettings newSettings = this.getOkHttpClientSettings();
        if (currentClient == null || !Intrinsics.areEqual((Object)this.okHttpClientSettings, (Object)newSettings)) {
            void var3_3;
            OkHttpClient newClient = this.createOkHttpClient(newSettings);
            this.okHttpClientSettings = newSettings;
            this.okHttpClient = newClient;
            okHttpClient = var3_3;
        } else {
            okHttpClient = currentClient;
        }
        return okHttpClient;
    }

    private final OkHttpClient createOkHttpClient(OkHttpClientSettings settings) {
        OkHttpClient.Builder builder;
        OkHttpClient.Builder $this$createOkHttpClient_u24lambda_u242 = builder = new OkHttpClient.Builder();
        boolean bl = false;
        if (settings.isDeveloperMode()) {
            $this$createOkHttpClient_u24lambda_u242.connectTimeout(settings.getConnectTimeout(), TimeUnit.SECONDS);
            $this$createOkHttpClient_u24lambda_u242.readTimeout(settings.getReadTimeout(), TimeUnit.SECONDS);
        } else {
            $this$createOkHttpClient_u24lambda_u242.connectTimeout(40L, TimeUnit.SECONDS);
            $this$createOkHttpClient_u24lambda_u242.readTimeout(40L, TimeUnit.SECONDS);
        }
        return builder.build();
    }

    private final OkHttpClientSettings getOkHttpClientSettings() {
        boolean bl = AcquiringSdk.Companion.isDeveloperMode();
        long l = AcquiringSdk.Companion.getRequestsTimeoutInterval();
        long l2 = AcquiringSdk.Companion.getRequestsTimeoutInterval();
        return new OkHttpClientSettings(bl, l2, l);
    }

    public static final /* synthetic */ String access$makeNetworkErrorMessage(NetworkClient $this, String message, String details) {
        return $this.makeNetworkErrorMessage(message, details);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0003\u001a\u00020\u0004\u00a8\u0006\u0005"}, d2={"Lru/tinkoff/acquiring/sdk/network/NetworkClient$Companion;", "", "()V", "createGson", "Lcom/google/gson/Gson;", "core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Gson createGson() {
            Object[] objectArray = new int[]{128, 8};
            GsonBuilder gsonBuilder = new GsonBuilder().disableHtmlEscaping().excludeFieldsWithModifiers(objectArray);
            objectArray = new ExclusionStrategy[1];
            objectArray[0] = (int)new SerializableExclusionStrategy();
            Gson gson = gsonBuilder.setExclusionStrategies((ExclusionStrategy[])objectArray).registerTypeAdapter((Type)((Object)CardStatus.class), (Object)new CardStatusSerializer()).registerTypeAdapter((Type)((Object)ResponseStatus.class), (Object)new PaymentStatusSerializer()).registerTypeAdapter((Type)((Object)GetCardListResponse.class), (Object)new CardsListDeserializer()).registerTypeAdapter((Type)((Object)Tax.class), (Object)new TaxSerializer()).registerTypeAdapter((Type)((Object)Taxation.class), (Object)new TaxationSerializer()).create();
            Intrinsics.checkNotNullExpressionValue((Object)gson, (String)"create(...)");
            return gson;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\t\n\u0002\b\r\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0007J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u000e\u001a\u00020\u0005H\u00c6\u0003J'\u0010\u000f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u0010\u001a\u00020\u00032\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\nR\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\t\u00a8\u0006\u0016"}, d2={"Lru/tinkoff/acquiring/sdk/network/NetworkClient$OkHttpClientSettings;", "", "isDeveloperMode", "", "connectTimeout", "", "readTimeout", "(ZJJ)V", "getConnectTimeout", "()J", "()Z", "getReadTimeout", "component1", "component2", "component3", "copy", "equals", "other", "hashCode", "", "toString", "", "core"})
    private static final class OkHttpClientSettings {
        private final boolean isDeveloperMode;
        private final long connectTimeout;
        private final long readTimeout;

        public OkHttpClientSettings(boolean isDeveloperMode, long connectTimeout, long readTimeout) {
            this.isDeveloperMode = isDeveloperMode;
            this.connectTimeout = connectTimeout;
            this.readTimeout = readTimeout;
        }

        public final boolean isDeveloperMode() {
            return this.isDeveloperMode;
        }

        public final long getConnectTimeout() {
            return this.connectTimeout;
        }

        public final long getReadTimeout() {
            return this.readTimeout;
        }

        public final boolean component1() {
            return this.isDeveloperMode;
        }

        public final long component2() {
            return this.connectTimeout;
        }

        public final long component3() {
            return this.readTimeout;
        }

        @NotNull
        public final OkHttpClientSettings copy(boolean isDeveloperMode, long connectTimeout, long readTimeout) {
            return new OkHttpClientSettings(isDeveloperMode, connectTimeout, readTimeout);
        }

        public static /* synthetic */ OkHttpClientSettings copy$default(OkHttpClientSettings okHttpClientSettings, boolean bl, long l, long l2, int n, Object object) {
            if ((n & 1) != 0) {
                bl = okHttpClientSettings.isDeveloperMode;
            }
            if ((n & 2) != 0) {
                l = okHttpClientSettings.connectTimeout;
            }
            if ((n & 4) != 0) {
                l2 = okHttpClientSettings.readTimeout;
            }
            return okHttpClientSettings.copy(bl, l, l2);
        }

        @NotNull
        public String toString() {
            return "OkHttpClientSettings(isDeveloperMode=" + this.isDeveloperMode + ", connectTimeout=" + this.connectTimeout + ", readTimeout=" + this.readTimeout + ")";
        }

        public int hashCode() {
            int result = Boolean.hashCode(this.isDeveloperMode);
            result = result * 31 + Long.hashCode(this.connectTimeout);
            result = result * 31 + Long.hashCode(this.readTimeout);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof OkHttpClientSettings)) {
                return false;
            }
            OkHttpClientSettings okHttpClientSettings = (OkHttpClientSettings)other;
            if (this.isDeveloperMode != okHttpClientSettings.isDeveloperMode) {
                return false;
            }
            if (this.connectTimeout != okHttpClientSettings.connectTimeout) {
                return false;
            }
            return this.readTimeout == okHttpClientSettings.readTimeout;
        }
    }
}

