package ru.tinkoff.acquiring.sdk;

import android.text.TextUtils;
import android.util.Log;

import java.util.LinkedList;

/**
 * @author a.shishkin1
 */
public class CollectLogger implements Logger {



    int size = 200;
    LinkedList<Object> entries = new LinkedList();
    Logger inner;

    public CollectLogger(Logger inner) {
        this.inner = inner;
    }

    @Override
    public void log(CharSequence message) {
        inner.log(message);
        addEntry(message);
    }

    @Override
    public void log(Throwable e) {
        inner.log(e);
        addEntry(e);
    }

    private void addEntry(Object obj) {
        entries.offer(obj);
        if (entries.size() > size) {
            entries.poll();
        }
    }

    static CollectLogger logger;

    public static void install() {
        logger = new CollectLogger(new JavaLogger());
        Journal.setLogger(logger);
    }

    public static String collectLog() {
        if (logger == null) {
            throw new NullPointerException("use CollectLogger.install before using collectLog");
        }
        return logger.toString();
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (Object o : entries) {
            sb.append(entryToString(o)).append("\n");
        }
        return sb.toString();
    }

    private String entryToString(Object o) {
        if (o instanceof Throwable) {
            Throwable t = (Throwable)o;
            String res = Log.getStackTraceString(t);
            if (TextUtils.isEmpty(res)) {
                return o.getClass().getCanonicalName();
            } else {
                return res;
            }
        } else if (o == null) {
            return "null";
        } else {
            return o.toString();
        }
    }
}
