package ru.tinkoff.acquiring.sdk.di

import android.content.Context
import org.koin.android.ext.koin.androidContext
import org.koin.core.Koin
import org.koin.core.KoinApplication
import org.koin.core.lazyModules
import org.koin.dsl.koinApplication
import ru.tinkoff.acquiring.sdk.AcquiringSdk
import ru.tinkoff.acquiring.sdk.di.modules.cardModule
import ru.tinkoff.acquiring.sdk.di.modules.koinPaymentModule
import ru.tinkoff.acquiring.sdk.di.modules.mainPaymentModule
import ru.tinkoff.acquiring.sdk.di.modules.mirPayModule
import ru.tinkoff.acquiring.sdk.di.modules.networkModule
import ru.tinkoff.acquiring.sdk.di.modules.qrModule
import ru.tinkoff.acquiring.sdk.di.modules.sbpModule
import ru.tinkoff.acquiring.sdk.di.modules.tPayModule
import ru.tinkoff.acquiring.sdk.di.modules.threeDsModule
import ru.tinkoff.acquiring.sdk.di.modules.utilModule

object TKoinContext {

    private var koinApp: KoinApplication? = null
    var koin: Koin? = null
    
    private val lazyModules = listOf(
        tPayModule(), sbpModule(), mirPayModule()
    )

    fun initKoinApp(context: Context, sdk: AcquiringSdk) {
        if (koin != null) {
            koin?.close()
        }
        koinApp = koinApplication {
            androidContext(context)
            modules(
                cardModule(),
                threeDsModule(),
                qrModule(),
                networkModule(),
                mainPaymentModule(),
                utilModule(),
                koinPaymentModule(sdk)
            )
            lazyModules(lazyModules)
        }
        koin = koinApp?.koin
    }
}