package ru.tinkoff.acquiring.sdk.di.modules

import androidx.lifecycle.SavedStateHandle
import org.koin.androidx.viewmodel.dsl.viewModel
import org.koin.dsl.module
import ru.tinkoff.acquiring.sdk.redesign.cards.list.presentation.CardsListFragmentViewModel
import ru.tinkoff.acquiring.sdk.redesign.cards.list.ui.CardListFlowViewModel
import ru.tinkoff.acquiring.sdk.redesign.payment.ui.PaymentByCardFlowViewModel
import ru.tinkoff.acquiring.sdk.ui.fragments.v2.AttachCardViewModelV2
import ru.tinkoff.acquiring.sdk.viewmodel.AttachCardFlowViewModel
import ru.tinkoff.acquiring.sdk.viewmodel.AttachCardViewModel


fun cardModule() = module {

    viewModel { (handle: SavedStateHandle) ->
        CardsListFragmentViewModel(
            handle,
            get(),
            get(),
            get(),
            get(),
        )
    }
    viewModel { (handle: SavedStateHandle) -> PaymentByCardFlowViewModel(handle) }
    viewModel { (handle: SavedStateHandle) -> CardListFlowViewModel(handle, get()) }
    viewModel { (handle: SavedStateHandle) ->
        AttachCardViewModel(
            get(),
            handle,
            get(),
            get(),
        )
    }
    viewModel { (handle: SavedStateHandle) ->
        AttachCardViewModelV2(
            get(),
            handle,
            get(),
            get(),
            get(),
        )
    }
    viewModel { (handle: SavedStateHandle) ->
        AttachCardFlowViewModel(
            handle,
            get(),
        )
    }
}
