package ru.tinkoff.acquiring.sdk.di.modules

import androidx.lifecycle.SavedStateHandle
import org.koin.dsl.module
import ru.tinkoff.acquiring.sdk.di.Scopes
import ru.tinkoff.acquiring.sdk.models.Card
import ru.tinkoff.acquiring.sdk.models.options.screen.PaymentOptions
import ru.tinkoff.acquiring.sdk.redesign.common.savedcard.SavedCardsRepository
import ru.tinkoff.acquiring.sdk.redesign.common.util.InstalledAppChecker
import ru.tinkoff.acquiring.sdk.redesign.mainform.navigation.MainFormNavController
import ru.tinkoff.acquiring.sdk.redesign.mainform.presentation.MainPaymentFormFactory
import ru.tinkoff.acquiring.sdk.redesign.mainform.presentation.analytics.MainFormAnalyticsDelegate
import ru.tinkoff.acquiring.sdk.redesign.mainform.presentation.primary.PrimaryButtonConfigurator
import ru.tinkoff.acquiring.sdk.redesign.mainform.presentation.process.MainFormPaymentProcessMapper
import ru.tinkoff.acquiring.sdk.redesign.mainform.presentation.secondary.SecondButtonConfigurator
import ru.tinkoff.acquiring.sdk.redesign.mainform.presentation.vm.MainFormInputCardViewModel
import ru.tinkoff.acquiring.sdk.redesign.mainform.presentation.vm.MainPaymentFormViewModel
import ru.tinkoff.acquiring.sdk.redesign.mainform.ui.MainPaymentFormFragment
import ru.tinkoff.acquiring.sdk.redesign.sbp.util.NspkBankAppsProvider
import ru.tinkoff.acquiring.sdk.redesign.sbp.util.NspkInstalledAppsChecker

fun mainPaymentModule() = module {
    scope<MainPaymentFormFragment> {
        scoped { (options: PaymentOptions, formFactory: MainPaymentFormFactory) ->
            MainPaymentFormViewModel(
                formFactory,
                get(),
                get(),
                get(),
                get(),
                options
            )
        }
        scoped { (handle: SavedStateHandle, options: PaymentOptions) ->
            MainFormInputCardViewModel(
                handle,
                get(),
                get(),
                get(),
                get(),
                options,
                get()
            )
        }
        scoped { MainFormNavController() }
        scoped { MainFormPaymentProcessMapper(get()) }
        scoped { (card: Card, paymentOptions: PaymentOptions) ->
            MainPaymentFormFactory(
                get(),
                get(),
                get(),
                get(),
                get(),
                get(),
                customerKey = paymentOptions.customer.customerKey,
                card = card,
                get(),
            )
        }
        scoped<PrimaryButtonConfigurator> {
            PrimaryButtonConfigurator.Impl(
                getScope(Scopes.SingleActivityScope.name).get<InstalledAppChecker>(),
                get(),
                get(),
                get()
            )
        }
        scoped<SecondButtonConfigurator> {
            SecondButtonConfigurator.Impl(
                getScope(Scopes.SingleActivityScope.name).get<InstalledAppChecker>(),
                getScope(Scopes.SingleActivityScope.name).get<NspkBankAppsProvider>(),
                getScope(Scopes.SingleActivityScope.name).get<NspkInstalledAppsChecker>(),
            )
        }
        scoped<SavedCardsRepository> { SavedCardsRepository.Impl(get()) }
        scoped<MainFormAnalyticsDelegate> { MainFormAnalyticsDelegate() }
    }
}