package ru.tinkoff.acquiring.sdk.di.modules

import kotlinx.coroutines.CoroutineScope
import kotlinx.coroutines.Dispatchers
import org.koin.dsl.lazyModule
import ru.tinkoff.acquiring.sdk.payment.MirPayProcess
import ru.tinkoff.acquiring.sdk.payment.methods.MirPayMethods
import ru.tinkoff.acquiring.sdk.payment.methods.MirPayMethodsImpl
import ru.tinkoff.acquiring.sdk.redesign.common.util.DeepLinkOpener
import ru.tinkoff.acquiring.sdk.redesign.common.util.DeepLinkOpenerImpl


fun mirPayModule() = lazyModule {

    factory { MirPayProcess(get(), get(), CoroutineScope(Dispatchers.IO)) }
    factory<MirPayMethods> { MirPayMethodsImpl(get()) }
    factory<DeepLinkOpener> { params -> DeepLinkOpenerImpl(params.get()) }
}
