package ru.tinkoff.acquiring.sdk.di.modules

import com.google.gson.Gson
import okhttp3.OkHttpClient
import org.koin.android.ext.koin.androidContext
import org.koin.core.qualifier.named
import org.koin.dsl.module
import ru.tinkoff.acquiring.sdk.di.Scopes
import ru.tinkoff.acquiring.sdk.payment.methods.Check3DsVersionMethods
import ru.tinkoff.acquiring.sdk.payment.methods.Check3DsVersionMethodsSdkImpl
import ru.tinkoff.acquiring.sdk.payment.methods.FinishAuthorizeMethods
import ru.tinkoff.acquiring.sdk.payment.methods.FinishAuthorizeMethodsSdkImpl
import ru.tinkoff.acquiring.sdk.payment.methods.InitMethods
import ru.tinkoff.acquiring.sdk.payment.methods.InitMethodsSdkImpl
import ru.tinkoff.acquiring.sdk.payment.pooling.GetStatusMethod
import ru.tinkoff.acquiring.sdk.payment.pooling.GetStatusPooling
import ru.tinkoff.acquiring.sdk.threeds.CertificateManager
import ru.tinkoff.acquiring.sdk.threeds.CertificateManagerImpl
import ru.tinkoff.acquiring.sdk.toggles.FeatureToggleApi
import ru.tinkoff.acquiring.sdk.utils.ConnectionChecker

fun networkModule() = module {
    scope(named(Scopes.SingleActivityScope.name)) {
        scoped<InitMethods> { InitMethodsSdkImpl(get()) }
        scoped<Check3DsVersionMethods> {
            Check3DsVersionMethodsSdkImpl(
                get(),
                androidContext(),
                get(),
                get()
            )
        }
        scoped<FinishAuthorizeMethods> { FinishAuthorizeMethodsSdkImpl(get()) }
        scoped<GetStatusMethod> { GetStatusMethod.Impl(get()) }
        scoped { GetStatusPooling(get()) }
    }
    factory { Gson() }
    factory {
        FeatureToggleApi(
            client = OkHttpClient(),
            gson = get(),
        )
    }
    factory { ConnectionChecker(androidContext()) }
    factory<CertificateManager> { CertificateManagerImpl(androidContext()) }
}