package ru.tinkoff.acquiring.sdk.di.modules

import androidx.lifecycle.SavedStateHandle
import org.koin.androidx.viewmodel.dsl.viewModel
import org.koin.dsl.module
import ru.tinkoff.acquiring.sdk.AcquiringSdk
import ru.tinkoff.acquiring.sdk.di.Scopes
import ru.tinkoff.acquiring.sdk.payment.PaymentByCardProcess
import ru.tinkoff.acquiring.sdk.payment.methods.Check3DsVersionMethods
import ru.tinkoff.acquiring.sdk.payment.methods.FinishAuthorizeMethods
import ru.tinkoff.acquiring.sdk.payment.methods.InitMethods
import ru.tinkoff.acquiring.sdk.payment.pooling.GetStatusPooling
import ru.tinkoff.acquiring.sdk.redesign.common.emailinput.EmailInputViewModel
import ru.tinkoff.acquiring.sdk.redesign.mainform.presentation.vm.MainPaymentFormFlowViewModel
import ru.tinkoff.acquiring.sdk.redesign.payment.ui.PaymentByCardViewModel
import ru.tinkoff.acquiring.sdk.redesign.payment.ui.v2.PaymentByNewCardViewModel
import ru.tinkoff.acquiring.sdk.redesign.payment.ui.v2.PaymentBySavedCardViewModel
import ru.tinkoff.acquiring.sdk.redesign.recurrent.ui.RecurrentPaymentFlowViewModel
import ru.tinkoff.acquiring.sdk.utils.BankCaptionProvider

fun koinPaymentModule(sdk: AcquiringSdk) = module {

    viewModel { (handle: SavedStateHandle) ->
        PaymentByCardViewModel(
            handle,
            get(),
            getScope(Scopes.SingleActivityScope.name).get<BankCaptionProvider>(),
        )
    }
    viewModel { (handle: SavedStateHandle) ->
        PaymentBySavedCardViewModel(
            handle,
            get(),
            getScope(Scopes.SingleActivityScope.name).get<BankCaptionProvider>(),
            get(),
        )
    }
    viewModel { (handle: SavedStateHandle) ->
        PaymentByNewCardViewModel(
            handle,
            get(),
            get(),
        )
    }
    viewModel { (handle: SavedStateHandle) ->
        RecurrentPaymentFlowViewModel(
            handle,
        )
    }
    viewModel { (handle: SavedStateHandle) -> MainPaymentFormFlowViewModel(handle) }
    viewModel { (handle: SavedStateHandle) -> EmailInputViewModel(handle) }
    single { sdk }
    factory {
        PaymentByCardProcess(
            getScope(Scopes.SingleActivityScope.name).get<InitMethods>(),
            getScope(Scopes.SingleActivityScope.name).get<Check3DsVersionMethods>(),
            getScope(Scopes.SingleActivityScope.name).get<FinishAuthorizeMethods>(),
            get(),
            getScope(Scopes.SingleActivityScope.name).get<GetStatusPooling>(),
            get(),
            get(),
        )
    }
}
