package ru.tinkoff.acquiring.sdk.di.modules

import androidx.lifecycle.SavedStateHandle
import org.koin.androidx.viewmodel.dsl.viewModel
import org.koin.dsl.module
import ru.tinkoff.acquiring.sdk.models.options.screen.PaymentOptions
import ru.tinkoff.acquiring.sdk.ui.activities.QrCodeFlowViewModel
import ru.tinkoff.acquiring.sdk.viewmodel.DynamicQrCodeViewModel
import ru.tinkoff.acquiring.sdk.viewmodel.StaticQrCodeViewModel

fun qrModule() = module {

    viewModel { (handle: SavedStateHandle) -> QrCodeFlowViewModel(handle) }
    viewModel { (paymentOptions: PaymentOptions) -> DynamicQrCodeViewModel(get(), paymentOptions) }
    viewModel { StaticQrCodeViewModel(get()) }
}