package ru.tinkoff.acquiring.sdk.di.modules

import androidx.lifecycle.SavedStateHandle
import org.koin.androidx.viewmodel.dsl.viewModel
import org.koin.dsl.lazyModule
import ru.tinkoff.acquiring.sdk.di.Scopes
import ru.tinkoff.acquiring.sdk.payment.SbpPaymentProcess
import ru.tinkoff.acquiring.sdk.payment.pooling.GetStatusPooling
import ru.tinkoff.acquiring.sdk.redesign.sbp.ui.SbpPaymentFlowViewModel
import ru.tinkoff.acquiring.sdk.redesign.sbp.ui.SbpPaymentViewModel
import ru.tinkoff.acquiring.sdk.redesign.sbp.util.NspkBankAppsProvider
import ru.tinkoff.acquiring.sdk.redesign.sbp.util.NspkBankAppsResolver
import ru.tinkoff.acquiring.sdk.redesign.sbp.util.NspkInstalledAppsChecker

fun sbpModule() = lazyModule {

    viewModel { (handle: SavedStateHandle) ->
        SbpPaymentViewModel(
            handle,
            get(),
            SbpPaymentProcess(
                get(),
                getScope(Scopes.SingleActivityScope.name).get<NspkInstalledAppsChecker>(),
                getScope(Scopes.SingleActivityScope.name).get<NspkBankAppsProvider>(),
                getScope(Scopes.SingleActivityScope.name).get<GetStatusPooling>()
            ),
            getScope(Scopes.SingleActivityScope.name).get<NspkBankAppsResolver>(),
        )
    }

    viewModel { (handle: SavedStateHandle) ->
        SbpPaymentFlowViewModel(
            handle
        )
    }
}
