package ru.tinkoff.acquiring.sdk.di.modules

import androidx.lifecycle.SavedStateHandle
import kotlinx.coroutines.CoroutineScope
import kotlinx.coroutines.Dispatchers
import org.koin.androidx.viewmodel.dsl.viewModel
import org.koin.dsl.lazyModule
import ru.tinkoff.acquiring.sdk.di.Scopes
import ru.tinkoff.acquiring.sdk.payment.TpayProcess
import ru.tinkoff.acquiring.sdk.payment.methods.GetTpayLinkMethodsSdkImpl
import ru.tinkoff.acquiring.sdk.payment.methods.TpayMethods
import ru.tinkoff.acquiring.sdk.payment.pooling.GetStatusPooling
import ru.tinkoff.acquiring.sdk.redesign.tpay.presentation.TpayViewModel

fun tPayModule() = lazyModule {
    viewModel { (handle: SavedStateHandle) ->
        TpayViewModel(
            handle,
            TpayProcess(
                getStatusPooling = getScope(Scopes.SingleActivityScope.name).get<GetStatusPooling>(),
                getTpayLinkMethods = get(),
                scope = CoroutineScope(Dispatchers.IO)
            ),
        )
    }
    factory<TpayMethods> { GetTpayLinkMethodsSdkImpl(get()) }
}