package ru.tinkoff.acquiring.sdk.di.modules

import androidx.lifecycle.SavedStateHandle
import org.koin.androidx.viewmodel.dsl.viewModel
import org.koin.dsl.module
import ru.tinkoff.acquiring.sdk.threeds.CreateAppBasedTransaction
import ru.tinkoff.acquiring.sdk.threeds.CreateAppBasedTransactionImpl
import ru.tinkoff.acquiring.sdk.threeds.ThreeDsAppBaseProcess
import ru.tinkoff.acquiring.sdk.threeds.ThreeDsAppBaseProcessImpl
import ru.tinkoff.acquiring.sdk.threeds.ThreeDsDataCollector
import ru.tinkoff.acquiring.sdk.threeds.ThreeDsHelper
import ru.tinkoff.acquiring.sdk.viewmodel.ThreeDsViewModel

fun threeDsModule() = module {

    viewModel { (handle: SavedStateHandle) -> ThreeDsViewModel(handle, get()) }

    factory<ThreeDsAppBaseProcess> { ThreeDsAppBaseProcessImpl(get()) }
    factory<ThreeDsDataCollector> { ThreeDsHelper.CollectDataClass() }
    factory<CreateAppBasedTransaction> { CreateAppBasedTransactionImpl(get(), get()) }
}