package ru.tinkoff.acquiring.sdk.di.modules

import org.koin.android.ext.koin.androidContext
import org.koin.core.qualifier.named
import org.koin.dsl.module
import ru.tinkoff.acquiring.sdk.di.Scopes
import ru.tinkoff.acquiring.sdk.models.NspkRequest
import ru.tinkoff.acquiring.sdk.redesign.common.util.InstalledAppChecker
import ru.tinkoff.acquiring.sdk.redesign.common.util.InstalledAppCheckerSdkImpl
import ru.tinkoff.acquiring.sdk.redesign.mainform.presentation.MergeMethodsStrategy
import ru.tinkoff.acquiring.sdk.redesign.sbp.util.NspkBankAppsProvider
import ru.tinkoff.acquiring.sdk.redesign.sbp.util.NspkBankAppsResolver
import ru.tinkoff.acquiring.sdk.redesign.sbp.util.NspkBankAppsResolverImpl
import ru.tinkoff.acquiring.sdk.redesign.sbp.util.NspkInstalledAppsChecker
import ru.tinkoff.acquiring.sdk.redesign.sbp.util.NspkInstalledAppsCheckerImpl
import ru.tinkoff.acquiring.sdk.toggles.DeviceIdProvider
import ru.tinkoff.acquiring.sdk.toggles.DeviceIdProviderImpl
import ru.tinkoff.acquiring.sdk.toggles.FeatureToggleManager
import ru.tinkoff.acquiring.sdk.ui.delegate.CardDataInputDelegate
import ru.tinkoff.acquiring.sdk.ui.delegate.CardDataInputDelegateImpl
import ru.tinkoff.acquiring.sdk.utils.BankCaptionProvider
import ru.tinkoff.acquiring.sdk.utils.BankCaptionResourceProvider
import ru.tinkoff.acquiring.sdk.utils.CoroutineManager

fun utilModule() = module {

    scope(named(Scopes.SingleActivityScope.name)) {
        scoped { androidContext().packageManager }
        scoped<InstalledAppChecker> { InstalledAppCheckerSdkImpl(get()) }
        scoped<NspkInstalledAppsChecker> { NspkInstalledAppsCheckerImpl(get()) }
        scoped<MergeMethodsStrategy> { MergeMethodsStrategy.ImplV1 }
        scoped {
            NspkBankAppsProvider {
                NspkRequest().execute().dictionary
            }
        }
        scoped<NspkBankAppsResolver>{ NspkBankAppsResolverImpl(get()) }
    }
    factory<BankCaptionProvider> { BankCaptionResourceProvider(androidContext()) }
    factory { CoroutineManager() }
    single<FeatureToggleManager> { FeatureToggleManager.getInstance(context = androidContext()) }
    single<DeviceIdProvider> { DeviceIdProviderImpl(androidContext()) }

    factory<CardDataInputDelegate> { CardDataInputDelegateImpl() }
}
