package ru.tinkoff.acquiring.sdk.payment.pooling

import ru.tinkoff.acquiring.sdk.AcquiringSdk
import ru.tinkoff.acquiring.sdk.exceptions.AcquiringApiException
import ru.tinkoff.acquiring.sdk.models.enums.ResponseStatus
import ru.tinkoff.acquiring.sdk.responses.GetStateResponse

/**
 * Created by i.golovachev
 */
fun interface GetStatusMethod {
    suspend operator fun invoke(paymentId: Long): ResponseStatus?

    class Impl(private val acquiringSdk: AcquiringSdk) : GetStatusMethod {

        override suspend fun invoke(paymentId: Long): ResponseStatus? {
            return try {
                acquiringSdk.getState { this.paymentId = paymentId }.execute().status
            } catch (e: Exception) {
                return tryExtractStatusFromError(e)
            }
        }

        private fun tryExtractStatusFromError(e: Exception): ResponseStatus? {
            val acquiringApiException = e as? AcquiringApiException ?: return null
            val response = acquiringApiException.response as? GetStateResponse ?: return null
            return response.status
        }
    }
}
