package ru.tinkoff.acquiring.sdk.redesign.cards.attach

import android.content.Context
import android.content.Intent
import androidx.activity.result.contract.ActivityResultContract
import ru.tinkoff.acquiring.sdk.models.options.screen.AttachCardOptions
import ru.tinkoff.acquiring.sdk.redesign.main.SingleActivity

object AttachCardLauncher {

        sealed class Result
        class Success(
            val cardId: String,
            val panSuffix: String
            ) : Result()
        class Canceled : Result()
        class Error(val error: Throwable) : Result()

        object Contract : ActivityResultContract<AttachCardOptions, Result>() {

            override fun createIntent(context: Context, options: AttachCardOptions): Intent {
                return SingleActivity.createIntent(context, SingleActivity.Arguments.AttachCardArguments(
                    options = options,
                    showError = true
                ))
            }

            override fun parseResult(resultCode: Int, intent: Intent?): Result {
                val result =
                    SingleActivity.getResult<SingleActivity.Result.AttachCardResult>(intent)
                return when (result) {
                    is SingleActivity.Result.AttachCardResult.Success -> {
                       Success(
                           cardId = result.cardId,
                           panSuffix = result.panSuffix
                       )
                    }
                    is SingleActivity.Result.AttachCardResult.Error -> {
                        Error(result.error)
                    }
                    else -> Canceled()
                }
            }
        }
    }
