package ru.tinkoff.acquiring.sdk.redesign.cards.list.ui

import ru.tinkoff.acquiring.sdk.models.Card
import ru.tinkoff.acquiring.sdk.redesign.cards.list.models.CardItemUiModel
import ru.tinkoff.acquiring.sdk.redesign.payment.ui.Notification

/**
 * Created by Ivan Golovachev
 */
data class ScreenState(
    val screenMode: ScreenMode,
    val listMode: CardListMode,
    val listState: CardsListState,
    val withArrowBack: Boolean = false,
    val allowNewCard: Boolean = true,
    val menuMode: MenuMode = MenuMode.EMPTY
) {
    companion object {
        val DEFAULT = ScreenState(
            screenMode = ScreenMode.LIST,
            listMode = CardListMode.LIST,
            listState = CardsListState.Shimmer
        )
    }
}

sealed class CardsListState {
    data object Shimmer : CardsListState()
    data class Empty(
        val notification: Notification
    ) : CardsListState()

    data class Error(
        val notification: Notification
    ) : CardsListState()

    data class NoNetwork(
        val notification: Notification
    ) : CardsListState()

    data class Content(val cards: List<CardItemUiModel>) : CardsListState()
}


sealed class CardListCommand {

    data object ToAttachCard : CardListCommand()

    data object ToPayByNewCard : CardListCommand()

    class FinishWithError(
        val throwable: Throwable
    ) : CardListCommand()

    class FinishWithSelectCard(val selectedCard: Card) : CardListCommand()

    data object FinishWithCancel : CardListCommand()

    class RemoveCardProgress(
        val deletedCard: CardItemUiModel
    ) : CardListCommand()

    class RemoveCardSuccess(
        val deletedCard: CardItemUiModel
    ) : CardListCommand()

    class ShowCardDeleteError(
        val error: Throwable,
        val maskedPan: String?
    ) : CardListCommand()
}

enum class ScreenMode {
    /**
     *  Отображение списка карт
     */
    LIST,
    /**
     * Выбор карты для оплаты
     */
    PAYMENT
}

enum class CardListMode {
    LIST, DELETE, CHOOSE
}

enum class MenuMode {
    /**
     * Действия отсутвтвуют
     */
    EMPTY,
    /**
     * Доступно редактирование
     */
    EDIT,
    /**
     * Доступно завершение редактирования
     */
    SUCCESS
}
