package ru.tinkoff.acquiring.sdk.redesign.common.util

import android.app.Activity
import androidx.annotation.VisibleForTesting

/**
 * @author s.y.biryukov
 */
interface DeepLinkOpener {
    fun openDeepLink(deepLink: String, requestCode: Int)

    companion object {
        @VisibleForTesting
        var catchDeepLinkOpenException: (String, Exception) -> Unit = {_, e ->  throw e }
    }
}

class DeepLinkOpenerImpl(val activity: Activity): DeepLinkOpener {
    override fun openDeepLink(deepLink: String, requestCode: Int) {
        try {
            activity.openDeepLink(requestCode, deepLink)
        } catch (e: Exception) {
            DeepLinkOpener.catchDeepLinkOpenException(deepLink, e)
        }
    }
}
