package ru.tinkoff.acquiring.sdk.redesign.common.util

import android.app.Activity
import android.content.Intent
import android.net.Uri

/**
 * @author k.shpakovskiy
 */
fun Activity.openDeepLink(
    requestCode: Int,
    deeplink: String
) {
    val intent = Intent(Intent.ACTION_VIEW)
    intent.data = Uri.parse(deeplink)
    intent.addFlags(Intent.FLAG_ACTIVITY_NEW_TASK)
    startActivityForResult(intent, requestCode)
}

fun Activity.openWebLink(url: String) {
    val intent = Intent(Intent.ACTION_VIEW, Uri.parse(url))
    startActivity(intent)
}
