package ru.tinkoff.acquiring.sdk.redesign.dialog

import ru.tinkoff.acquiring.sdk.R
import ru.tinkoff.acquiring.sdk.exceptions.AcquiringSdkTimeoutException
import ru.tinkoff.acquiring.sdk.ui.customview.status.StatusViewData
import ru.tinkoff.acquiring.sdk.utils.Money

sealed class PaymentStatusSheetState(
        open val title: Int?,
        open val subtitle: Int? = null,
        open val button: Int? = null,
) {
    class Error(
        title: Int = R.string.acq_commonsheet_failed_title,
        subtitle: Int? = null,
        mainButton: Int? = null,
        val throwable: Throwable
    ) : PaymentStatusSheetState(title, subtitle, mainButton)

    class Success(
        title: Int? = null,
        subtitle: Int? = R.string.acq_commonsheet_paid_title,
        button: Int? = R.string.acq_commonsheet_clear_primarybutton,
        val amount: Money?,
        var paymentId: Long,
        var cardId: String? = null,
        var rebillId: String? = null
    ) : PaymentStatusSheetState(title, subtitle, button)
}

internal fun PaymentStatusSheetState.toStatusType() = when (this) {
    is PaymentStatusSheetState.Error -> {
        when (throwable) {
            is AcquiringSdkTimeoutException -> StatusViewData.Type.PAYMENT_TIMEOUT
            else -> StatusViewData.Type.ERROR
        }
    }

    is PaymentStatusSheetState.Success -> StatusViewData.Type.SUCCESS
}
