package ru.tinkoff.acquiring.sdk.redesign.mainform.presentation

import ru.tinkoff.acquiring.sdk.models.Card
import ru.tinkoff.acquiring.sdk.redesign.payment.model.CardChosenModel
import ru.tinkoff.acquiring.sdk.responses.Paymethod
import ru.tinkoff.acquiring.sdk.responses.TerminalInfo

internal object MainPaymentForm {

    data class State(
        val ui: Ui,
        val data: Data,
        val noInternet: Boolean = false,
    )

    data class Ui(
        val primary: Primary,
        val secondaries: Set<Secondary>,
        val isLogoVisible: Boolean = true,
    )

    data class Data(
        val info: TerminalInfo?,
        val cards: List<Card>,
        val chosen: Card?
    )

    sealed class Primary(val paymethod: Paymethod) {

        data object Tpay : Primary(Paymethod.TinkoffPay)

        data object Spb : Primary(Paymethod.SBP)

        data object MirPay : Primary(Paymethod.MirPay)

        data class Card(val selectedCard: CardChosenModel?) : Primary(Paymethod.Cards)
    }

    sealed class Secondary(val paymethod: Paymethod, val order: Int) {
        data object Tpay : Secondary(Paymethod.TinkoffPay, 1)

        data object MirPay: Secondary(Paymethod.MirPay, 5)

        data object Spb : Secondary(Paymethod.SBP, 3)

        data object Cards : Secondary(Paymethod.Cards, 2)
    }
}
