package ru.tinkoff.acquiring.sdk.redesign.mainform.presentation.process

import ru.tinkoff.acquiring.sdk.R
import ru.tinkoff.acquiring.sdk.payment.PaymentByCardState
import ru.tinkoff.acquiring.sdk.redesign.dialog.PaymentStatusSheetState
import ru.tinkoff.acquiring.sdk.redesign.mainform.navigation.MainFormNavController

/**
 * Created by i.golovachev
 */
internal class MainFormPaymentProcessMapper(private val mainFormNavController: MainFormNavController) { // PaymentStatusSheetState
    suspend operator fun invoke(it: PaymentByCardState): PaymentStatusSheetState? {
        return when (it) {
            is PaymentByCardState.Error -> PaymentStatusSheetState.Error(
                title = R.string.acq_commonsheet_failed_title,
                subtitle = R.string.acq_commonsheet_payment_failed_description_retry,
                mainButton = R.string.acq_commonsheet_clear_primarybutton,
                throwable = it.throwable
            )

            is PaymentByCardState.Success -> PaymentStatusSheetState.Success(
                subtitle = R.string.acq_commonsheet_paid_title,
                button = R.string.acq_commonsheet_clear_primarybutton,
                paymentId = it.paymentId,
                cardId = it.cardId,
                rebillId = it.rebillId,
                amount = it.amount,
            )
            PaymentByCardState.ThreeDsInProcess -> {
                null
            }
            is PaymentByCardState.ThreeDsUiNeeded -> {
                mainFormNavController.to3ds(it.paymentOptions, it.threeDsState, it.paymentSource)
                null
            }
            is PaymentByCardState.ThreeDsAppBase -> {
                mainFormNavController.toAppBaseChallenge(it.transaction, it.threeDsData)
                null
            }
            is PaymentByCardState.Started,
            PaymentByCardState.Created,
            PaymentByCardState.Cancelled,
            is PaymentByCardState.CvcUiNeeded,
            is PaymentByCardState.CvcUiInProcess -> null
        }
    }
}
