package ru.tinkoff.acquiring.sdk.redesign.mainform.ui

import android.os.Parcelable
import kotlinx.parcelize.Parcelize
import ru.tinkoff.acquiring.sdk.models.Card
import ru.tinkoff.acquiring.sdk.models.ThreeDsData
import ru.tinkoff.acquiring.sdk.models.options.screen.PaymentOptions
import ru.tinkoff.acquiring.sdk.redesign.cards.list.ChooseCardLauncher

sealed interface MainPaymentFormResult : Parcelable {

    @Parcelize
    data object FinishCancelled : MainPaymentFormResult

    @Parcelize
    data class FinishSuccess(
        val paymentId: Long,
        val cardId: String? = null,
        val rebillId: String? = null

    ) : MainPaymentFormResult

    @Parcelize
    data class FinishError(
        val error: Throwable
    ) : MainPaymentFormResult

    @Parcelize
    data class PayByCard(
        val paymentOptions: PaymentOptions,
        val cards: List<Card>,
        val withArrowBack: Boolean
    ) : MainPaymentFormResult

    @Parcelize
    class PayBySbp(
        val paymentOptions: PaymentOptions
    ) : MainPaymentFormResult

    @Parcelize
    class PayByMirPay(
        val paymentOptions: PaymentOptions
    ) : MainPaymentFormResult

    @Parcelize
    class PayByTpay(
        val paymentOptions: PaymentOptions,
        val version: String
    ) : MainPaymentFormResult

    @Parcelize
    class ChangeCard(
        val startData: ChooseCardLauncher.StartData
    ) : MainPaymentFormResult

    @Parcelize
    class NeedThreeDs(
        val options: PaymentOptions,
        val data: ThreeDsData,
        val panSuffix: String
    ) : MainPaymentFormResult
}
