package ru.tinkoff.acquiring.sdk.redesign.mirpay

import android.content.Context
import android.content.Intent
import android.os.Parcelable
import androidx.activity.result.contract.ActivityResultContract
import kotlinx.parcelize.Parcelize
import ru.tinkoff.acquiring.sdk.models.options.screen.PaymentOptions
import ru.tinkoff.acquiring.sdk.redesign.common.result.AcqPaymentResult
import ru.tinkoff.acquiring.sdk.redesign.main.SingleActivity
import ru.tinkoff.acquiring.sdk.redesign.main.SingleActivity.Result.MirPayPaymentResult

/**
 * @author k.shpakovskiy
 */
object MirPayLauncher {

    sealed class Result

    class Success(
        override val paymentId: Long,
        override val cardId: String? = null,
        override val rebillId: String? = null
    ) : Result(), AcqPaymentResult.Success, java.io.Serializable

    data object Canceled : Result(), AcqPaymentResult.Canceled, java.io.Serializable

    class Error(
        override val error: Throwable,
        override val errorCode: Int?,
        override val paymentId: Long?
    ) : Result(), AcqPaymentResult.Error, java.io.Serializable

    @Parcelize
    class StartData(val paymentOptions: PaymentOptions) : Parcelable

    object Contract : ActivityResultContract<StartData, Result>() {

        override fun createIntent(context: Context, startData: StartData): Intent =
            SingleActivity.createIntent(
                context, SingleActivity.Arguments.MirPayPaymentArguments(
                    options = startData.paymentOptions
                )
            )

        override fun parseResult(resultCode: Int, intent: Intent?): Result {
            return when (val result: MirPayPaymentResult? = SingleActivity.getResult(intent)) {
                is MirPayPaymentResult.Success -> {
                    Success(
                        paymentId = result.paymentId
                    )
                }

                is MirPayPaymentResult.Error -> {
                    Error(
                        error = result.error,
                        errorCode = result.errorCode,
                        paymentId = result.paymentId,
                    )
                }

                else -> Canceled
            }
        }
    }
}
