package ru.tinkoff.acquiring.sdk.redesign.mirpay.ui

import android.os.Parcelable
import kotlinx.parcelize.Parcelize

sealed interface MirPaymentResult : Parcelable {

    @Parcelize
    data object Canceled : MirPaymentResult

    @Parcelize
    data class Error(
        val error: Throwable,
        val paymentId: Long?,
        val errorCode: String?,
    ) : MirPaymentResult

    @Parcelize
    data class Success(
        val paymentId: Long,
        val cardId: String? = null,
        val rebillId: String? = null,
    ) : MirPaymentResult
}
