package ru.tinkoff.acquiring.sdk.redesign.payment.ui

import androidx.annotation.StringRes
import ru.tinkoff.acquiring.sdk.ui.customview.status.StatusViewData
import ru.tinkoff.acquiring.sdk.utils.Money

data class Notification(
    val type: StatusViewData.Type,
    @StringRes val title: Int? = null,
    @StringRes val description: Int? = null,
    @StringRes val button: Int? = null,
    val amount: Money? = null
) {
    var onButtonClick: (() -> Unit)? = null
        private set
    var onCloseByUser: (() -> Unit)? = null
        private set

    constructor(
        type: StatusViewData.Type,
        title: Int? = null,
        description: Int? = null,
        button: Int? = null,
        amount: Money? = null,
        onClick: (() -> Unit)? = null,
        onClose: (() -> Unit)? = null
    ) : this(type, title, description, button, amount) {
        this.onButtonClick = onClick
        this.onCloseByUser = onClose
    }

    /**
     * @property isTerminal Указывает на то что по клику
     * на кнопку окно должно быть закрыто без возможности выбора других вариантов
     */
    class Options(
        val isTerminal: Boolean = true
    )
}
