package ru.tinkoff.acquiring.sdk.redesign.payment.ui.v2

import androidx.lifecycle.ViewModel
import kotlinx.coroutines.flow.SharedFlow
import kotlinx.coroutines.flow.StateFlow

/**
 * @author s.y.biryukov
 */
abstract class AbstractPaymentByCardViewModel<S, C> : ViewModel() {
    abstract val stateFlow: StateFlow<S>
    abstract val commandFlow: SharedFlow<C>

    private var isFirstTime: Boolean = true

    abstract fun onViewResume(isFirstTime: Boolean)

    abstract fun validateCvc(cvc:String)

    protected fun onCvcChanged(cvc: String) {
        validateCvc(cvc)
    }

    fun onViewResume() {
        onViewResume(isFirstTime)
        isFirstTime = false
    }
}
