package ru.tinkoff.acquiring.sdk.redesign.payment.ui.v2

import android.content.Context
import android.text.method.PasswordTransformationMethod
import android.util.AttributeSet
import android.view.LayoutInflater
import androidx.cardview.widget.CardView
import ru.tinkoff.acquiring.sdk.R
import ru.tinkoff.acquiring.sdk.databinding.AcqLayoutChoosenCardV2Binding
import ru.tinkoff.acquiring.sdk.utils.SimpleTextWatcher.Companion.onTextChanged
import ru.tinkoff.acquiring.sdk.viewmodel.CardLogoProvider
import ru.tinkoff.decoro.MaskImpl
import ru.tinkoff.decoro.parser.UnderscoreDigitSlotsParser
import ru.tinkoff.decoro.watchers.MaskFormatWatcher

/**
 * @author s.y.biryukov
 */
class ChosenCardView @JvmOverloads constructor(
    context: Context,
    attrs: AttributeSet? = null,
    defStyleAttr: Int = 0
) : CardView(context, attrs, defStyleAttr) {
    private val viewBinding =
        AcqLayoutChoosenCardV2Binding.inflate(LayoutInflater.from(context), this, true)

    var listener: Listener? = null

    init {
        viewBinding.cvcInput.apply {
            transformationMethod = PasswordTransformationMethod()
            MaskFormatWatcher(createCvcMask()).installOn(editText)
            editText.onTextChanged { listener?.onCvcChanged(it.toString()) }
            textInputLayout.addFocusChangeListener { listener?.onFocusChanged(it.isFocused) }
        }
        viewBinding.acqCardChange.setOnClickListener {
            listener?.onChangeCard()
        }
    }

    fun setData(number:String, bankName: String?) {
        viewBinding.acqCardChoosenItem.text = context.getString(
            R.string.acq_cardlist_bankname, bankName.orEmpty(), number.takeLast(4)
        )

        viewBinding.acqCardChoosenItemLogo.setImageResource(CardLogoProvider.getCardLogo(number))
    }

    fun focusCvc() {
        viewBinding.cvcInput.requestViewFocus()
    }

    fun setCvcError(isError: Boolean) {
        viewBinding.cvcInput.errorHighlighted = isError
    }

    override fun setEnabled(enabled: Boolean) {
        super.setEnabled(enabled)
        viewBinding.cvcInput.apply {
            isEnabled = enabled
            editable = enabled
        }

        viewBinding.acqCardChange.isEnabled = enabled
    }

    companion object {
        private const val CVC_MASK = "___"
        fun createCvcMask(): MaskImpl = MaskImpl.createTerminated(UnderscoreDigitSlotsParser()
            .parseSlots(CVC_MASK))
    }

    interface Listener {
        fun onChangeCard()
        fun onCvcChanged(cvc:String)
        fun onFocusChanged(isCvcFocused: Boolean)
    }
}
