package ru.tinkoff.acquiring.sdk.redesign.payment.ui.v2

import android.content.Context
import android.graphics.Rect
import android.util.AttributeSet
import android.view.LayoutInflater
import android.widget.FrameLayout
import ru.tinkoff.acquiring.sdk.databinding.AcqFragmentEmailInputBinding
import ru.tinkoff.acquiring.sdk.smartfield.BaubleClearButton
import ru.tinkoff.acquiring.sdk.utils.SimpleTextWatcher.Companion.onTextChanged

/**
 * @author s.y.biryukov
 */
class EmailInputView @JvmOverloads constructor(
    context: Context,
    attrs: AttributeSet? = null,
    defStyleAttr: Int = 0
) : FrameLayout(context, attrs, defStyleAttr) {
    private val viewBinding =
        AcqFragmentEmailInputBinding.inflate(LayoutInflater.from(context), this, true)

    var listener: Listener? = null

    init {
        BaubleClearButton().apply {
            attach(viewBinding.emailInput)
        }

        viewBinding.emailInput.editText.onTextChanged { listener?.onEmailChanged(it.toString()) }
        viewBinding.emailInput.textInputLayout.addFocusChangeListener { listener?.onFocusChanged(it.isFocused) }
    }

    fun setData(email:String?) {
        viewBinding.emailInput.editText.setText(email.orEmpty())
    }

    fun setError(isError: Boolean) {
        viewBinding.emailInput.errorHighlighted = isError
    }

    override fun requestFocus(direction: Int, previouslyFocusedRect: Rect?): Boolean {
        viewBinding.emailInput.requestViewFocus()
        return true
    }

    override fun setEnabled(enabled: Boolean) {
        super.setEnabled(enabled)
        viewBinding.emailInput.apply {
            isEnabled = enabled
            editable = enabled
        }
    }

    interface Listener {
        fun onEmailChanged(email: String)
        fun onFocusChanged(isEmailFocused: Boolean)
    }
}
