package ru.tinkoff.acquiring.sdk.redesign.sbp

import android.content.Context
import android.content.Intent
import android.os.Parcelable
import androidx.activity.result.contract.ActivityResultContract
import kotlinx.parcelize.Parcelize
import ru.tinkoff.acquiring.sdk.models.options.screen.PaymentOptions
import ru.tinkoff.acquiring.sdk.redesign.main.SingleActivity
import ru.tinkoff.acquiring.sdk.redesign.main.SingleActivity.Result.SbpPaymentResult

/**
 * @author k.shpakovskiy
 */
object SbpPayLauncher {

    sealed class Result
    class Success(val payment: Long) : Result()
    data object Canceled : Result()
    class Error(val error: Throwable) : Result()
    data object NoBanks : Result()

    @Parcelize
    class StartData(val paymentOptions: PaymentOptions) : Parcelable

    object Contract : ActivityResultContract<StartData, Result>() {

        override fun createIntent(context: Context, data: StartData): Intent =
            SingleActivity.createIntent(
                context, SingleActivity.Arguments.SbpPaymentArguments(
                    options = data.paymentOptions
                )
            )

        override fun parseResult(resultCode: Int, intent: Intent?): Result {
            return when (val result: SbpPaymentResult? = SingleActivity.getResult(intent)) {
                is SbpPaymentResult.Success -> Success(
                    payment = result.paymentId
                )

                is SbpPaymentResult.Error -> Error(
                    error = result.error
                )
                else -> Canceled
            }
        }
    }
}
