package ru.tinkoff.acquiring.sdk.redesign.sbp.ui

import android.content.Intent
import android.net.Uri
import android.os.Bundle
import android.os.Parcelable
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import androidx.activity.addCallback
import androidx.appcompat.app.AppCompatActivity
import androidx.core.os.bundleOf
import androidx.fragment.app.Fragment
import androidx.fragment.app.FragmentManager
import androidx.lifecycle.LifecycleOwner
import kotlinx.parcelize.Parcelize
import ru.tinkoff.acquiring.sdk.databinding.FragmentSbpNoBanksStubBinding

class SbpNoBanksStubFragment : Fragment() {

    private var binding: FragmentSbpNoBanksStubBinding? = null

    override fun onCreateView(
        inflater: LayoutInflater,
        container: ViewGroup?,
        savedInstanceState: Bundle?
    ): View {
        return FragmentSbpNoBanksStubBinding.inflate(inflater, container, false)
            .also { this.binding = it }
            .root
    }

    override fun onViewCreated(view: View, savedInstanceState: Bundle?) {
        super.onViewCreated(view, savedInstanceState)

        initToolbar()

        requireActivity().onBackPressedDispatcher.addCallback(viewLifecycleOwner) {
            setResult(Result.Cancel)
        }

        binding?.acqButtonOk?.setOnClickListener {
            setResult(Result.Cancel)
        }

        binding?.acqButtonDetails?.setOnClickListener {
            val browserIntent =
                Intent(Intent.ACTION_VIEW, Uri.parse(URL_NSPK))
            startActivity(browserIntent)
        }
    }

    private fun initToolbar() {
        binding?.acqToolbar?.let { toolbar ->
            val activity = (requireActivity() as? AppCompatActivity)
            activity?.setSupportActionBar(toolbar)
            activity?.supportActionBar?.setDisplayHomeAsUpEnabled(true)
            activity?.supportActionBar?.setDisplayShowHomeEnabled(true)
            toolbar.setNavigationOnClickListener {
                setResult(Result.Cancel)
            }
        }
    }

    private fun setResult(result: Result) {
        parentFragmentManager.setFragmentResult(
            FRAGMENT_RESULT_KEY, bundleOf(
                FRAGMENT_RESULT_BUNDLE_KEY to result
            )
        )
    }

    override fun onDestroyView() {
        super.onDestroyView()
        binding = null
    }

    companion object {
        private const val TAG = "SbpNoBanksStubFragment"
        private const val FRAGMENT_RESULT_KEY = "$TAG.FRAGMENT_RESULT_KEY"
        private const val FRAGMENT_RESULT_BUNDLE_KEY = "$TAG.FRAGMENT_RESULT_BUNDLE_KEY"

        private const val URL_NSPK = "https://sbp.nspk.ru/participants/"

        @JvmStatic
        fun newInstance() = SbpNoBanksStubFragment()

        fun registerResultListener(
            fragmentManager: FragmentManager,
            lifecycleOwner: LifecycleOwner,
            listener: (Result) -> Unit
        ) {
            fragmentManager.setFragmentResultListener(
                FRAGMENT_RESULT_KEY,
                lifecycleOwner
            ) { _, bundle ->
                val result =
                    bundle.getParcelable<Result>(FRAGMENT_RESULT_BUNDLE_KEY)

                result?.let(listener)
            }
        }
    }

    interface Result: Parcelable {
        @Parcelize
        data object Cancel : Result
    }
}
