package ru.tinkoff.acquiring.sdk.redesign.sbp.ui

import android.os.Parcelable
import kotlinx.parcelize.Parcelize

sealed interface SbpPaymentResult : Parcelable {

    @Parcelize
    data object EmptyBanks : SbpPaymentResult

    @Parcelize
    data object CloseWithCancel: SbpPaymentResult

    @Parcelize
    data class CloseWithSuccess(
        val paymentId: Long,
    ) : SbpPaymentResult

    @Parcelize
    data class CloseWithError(
        val error: Throwable,
        val errorCode: Int? = null,
    ) : SbpPaymentResult
}
