package ru.tinkoff.acquiring.sdk.redesign.sbp.util

import android.content.pm.PackageManager
import ru.tinkoff.acquiring.sdk.redesign.common.util.InstalledAppCheckerSdkImpl
import ru.tinkoff.acquiring.sdk.responses.NspkC2bResponse

/**
 * Created by i.golovachev
 */
fun interface NspkInstalledAppsChecker {

    suspend fun checkInstalledApps(nspkBanks: List<NspkC2bResponse.NspkAppInfo>, deeplink: String): List<NspkBank>
}

class NspkBank(
    val packageName: String,
    val deepLink: String,
    val weblink: String? = null,
)

class NspkInstalledAppsCheckerImpl(val packageManager: PackageManager) : NspkInstalledAppsChecker {

    override suspend fun checkInstalledApps(
        nspkBanks: List<NspkC2bResponse.NspkAppInfo>,
        deeplink: String
    ): List<NspkBank>{
        return SbpHelper.getBankApps(resolvePackageManager(), deeplink, nspkBanks)
    }

    private fun resolvePackageManager() = (InstalledAppCheckerSdkImpl.testPackageManager ?: packageManager)
}
