package ru.tinkoff.acquiring.sdk.redesign.tpay.ui

import android.os.Parcelable
import kotlinx.parcelize.Parcelize

sealed interface TPayResult : Parcelable {

    @Parcelize
    class Success(
        val paymentId: Long,
        val cardId: String? = null,
        val rebillId: String? = null
    ) : TPayResult

    @Parcelize
    data object Canceled : TPayResult

    @Parcelize
    class Error(
        val error: Throwable,
        val errorCode: Int?,
        val paymentId: Long?
    ) : TPayResult
}
