package ru.tinkoff.acquiring.sdk.threeds

import ru.tinkoff.acquiring.sdk.responses.Check3dsVersionResponse

interface ThreeDsAppBaseProcess {

    suspend fun collectInfo(dsData: Check3dsVersionResponse): AppBaseProcessResult
}

class ThreeDsAppBaseProcessImpl(
    private val createAppBasedTransaction: CreateAppBasedTransaction,
) : ThreeDsAppBaseProcess {

    override suspend fun collectInfo(dsData: Check3dsVersionResponse): AppBaseProcessResult {

        if (dsData.paymentSystem.isNullOrEmpty()) {
            return AppBaseProcessResult.Error(IllegalStateException("PaymentSystem = ${dsData.paymentSystem}"))
        }

        val resultData = mutableMapOf<String, String>()
        val transaction = createAppBasedTransaction.invoke(
            threeDsVersion = requireNotNull(dsData.version),
            paymentSystem = requireNotNull(dsData.paymentSystem),
            data = resultData
        )
        return AppBaseProcessResult.Success(
            resultData, transaction
        )
    }
}

sealed interface AppBaseProcessResult {

    data class Error(val throwable: IllegalStateException) : AppBaseProcessResult

    data class Success(
        val threedsData: Map<String, String>,
        val transaction: ThreeDsAppBasedTransaction
    ) : AppBaseProcessResult
}
