package ru.tinkoff.acquiring.sdk.threeds

import android.os.Parcelable
import kotlinx.parcelize.Parcelize
import java.io.Serializable

data class ThreeDsDataSDK(
    val sdkAppID: String,
    val sdkEphemPubKey: String,
    val sdkReferenceNumber: String,
    val sdkTransID: String,
    val sdkMaxTimeout: String,
    val sdkEncData: String,
    val sdkUiTypes: String,
    val sdkInterface: String,
) : Serializable

fun threeDsFromMap(data: Map<String, String>) = ThreeDsDataSDK(
    sdkAppID = requireNotNull(data[SDK_MAP_APP_ID_KEY]),
    sdkEphemPubKey = requireNotNull(data[SDK_EPHEM_PUB_KEY]),
    sdkReferenceNumber = requireNotNull(data[SDK_REFERENCE_NUMBER_KEY]),
    sdkTransID = requireNotNull(data[SDK_TRANS_ID_KEY]),
    sdkMaxTimeout = requireNotNull(data[SDK_MAX_TIMEOUT_KEY]),
    sdkEncData = requireNotNull(data[SDK_ENC_DATA_KEY]),
    sdkUiTypes = requireNotNull(data[SDK_UI_TYPE_KEY]),
    sdkInterface = requireNotNull(data[SDK_INTERFACE_KEY]),
)

fun threeDsToMap(data: ThreeDsDataSDK) = mapOf<String,String>(
    SDK_MAP_APP_ID_KEY to data.sdkAppID,
    SDK_EPHEM_PUB_KEY to data.sdkEphemPubKey,
    SDK_REFERENCE_NUMBER_KEY to data.sdkReferenceNumber,
    SDK_TRANS_ID_KEY to data.sdkTransID,
    SDK_MAX_TIMEOUT_KEY to data.sdkMaxTimeout,
    SDK_ENC_DATA_KEY to data.sdkEncData,
    SDK_UI_TYPE_KEY to data.sdkUiTypes,
    SDK_INTERFACE_KEY to data.sdkInterface,
)
