package ru.tinkoff.acquiring.sdk.threeds
import android.util.Log
import com.emvco3ds.sdk.spec.Logger

internal class ThreeDsLogger : Logger {

    override fun log(level: Logger.Level?, message: String?, file: String?, method: String?, line: Int, error: Throwable?) {
        when (level) {
            Logger.Level.DEBUG, Logger.Level.INFO, Logger.Level.VERBOSE, Logger.Level.WARNING -> debug(message)
            Logger.Level.ERROR -> error(error, errorMessage(message, file, method, line))
            null -> Unit
        }
    }

    private fun debug(message: String?) {
        if (message.isNullOrBlank()) return
        Log.e(TAG,"ThreeDsV2 SDK: $message")
    }

    private fun error(error: Throwable?, message: String) {
        Log.e(TAG, "$error ThreeDsV2 SDK Error: $message")
    }

    private fun errorMessage(message: String?, file: String?, method: String?, line: Int): String {
        val logMessage = message.orEmpty()
        val logFile = file ?: "Unknown"
        val logMethod = method ?: "Unknown"
        return "$logFile.$logMethod:$line, $logMessage"
    }

    private companion object {
        const val TAG: String = "ThreeDsLogger"
    }
}