package ru.tinkoff.acquiring.sdk.toggles

import org.json.JSONObject
import ru.tinkoff.acquiring.sdk.AcquiringSdk
import ru.tinkoff.acquiring.sdk.toggles.toggles.AppBaseFeatureToggle

/**
 * @author s.y.biryukov
 */
suspend fun Map<String, String>?.withToggleInfo(): Map<String, String> {
    val resultMap = this?.toMutableMap() ?: mutableMapOf()

    try {
        val featureToggleManager = FeatureToggleManager.requireInstance()
        val featureToggleValue = featureToggleManager.getFeatureToggleValue(AppBaseFeatureToggle)
        if (featureToggleValue != null) {
            val json = JSONObject()
                .put("value", featureToggleValue.booleanValue.toString())
                .put("deviceId", featureToggleManager.getFeatureToggleContext()?.deviceId)
            if (isRemoteValue(featureToggleValue)) {
                json.put("dcoStatusApplied", featureToggleValue.dcoStatusApplied)
            } else {
                json.put("default", featureToggleValue.booleanValue.toString())
            }

            val threeDsVersion = featureToggleManager.getFeatureToggleContext()?.threeDsVersion
            json.put("3DS", threeDsVersion)
            resultMap[featureToggleValue.path] = json.toString()
        }
    } catch (e: Exception) {
        AcquiringSdk.log(e)
    }

    return resultMap
}

private fun isRemoteValue(featureToggleValue: FeatureToggleValue): Boolean {
    val source = featureToggleValue.source
    return source != Source.DEVELOP && source != Source.DEFAULT_LOCAL
}
