package ru.tinkoff.acquiring.sdk.toggles

import com.google.gson.annotations.SerializedName

/**
 * @author s.y.biryukov
 */
data class FeatureToggleValue(
    @SerializedName("path")
    val path: String,
    @SerializedName("stringValue")
    val stringValue: String? = null,
    @SerializedName("booleanValue")
    val booleanValue: Boolean? = null,
    @SerializedName("source")
    val source: Source = Source.REMOTE,
    @SerializedName("dcoStatusApplied")
    val dcoStatusApplied: String? = null,
)

enum class Source {
    DEFAULT_LOCAL, CACHE_MEMORY, CACHE_DISK, DEVELOP, REMOTE
}

