package ru.tinkoff.acquiring.sdk.toggles.cache

import ru.tinkoff.acquiring.sdk.toggles.FeatureToggleValue
import ru.tinkoff.acquiring.sdk.toggles.Source
import java.util.Date

/**
 * @author s.y.biryukov
 */
open class InMemoryFeatureToggleCache : FeatureToggleCache {
    private var toggles: List<FeatureToggleValue>? = null
    private var createDate: Date? = null
    private var featureToggleContextKey: String? = null

    override suspend fun getFeatureToggles(): List<FeatureToggleValue>? {
        return toggles
    }

    override suspend fun setFeatureToggles(
        toggles: List<FeatureToggleValue>?,
        createDate: Date,
        contextKey: String?
    ) {
        val memoryToggles = toggles?.map { it.copy(source = Source.CACHE_MEMORY) }
        this.toggles = memoryToggles
        this.createDate = createDate
        this.featureToggleContextKey = contextKey
    }

    override suspend fun getCreateDate(): Date? {
        return createDate
    }

    override suspend fun clear() {
        this.createDate = null
        this.toggles = null
    }

    override suspend fun getFeatureToggleContextKey(): String = featureToggleContextKey.orEmpty()
}
