package ru.tinkoff.acquiring.sdk.toggles.develop

import android.content.Context
import androidx.core.content.edit
import com.google.gson.Gson
import com.google.gson.reflect.TypeToken
import kotlinx.coroutines.Dispatchers
import kotlinx.coroutines.withContext
import ru.tinkoff.acquiring.sdk.toggles.FeatureToggleValue
import ru.tinkoff.acquiring.sdk.toggles.Source
import ru.tinkoff.acquiring.sdk.toggles.toggles.FeatureToggle

/**
 * @author s.y.biryukov
 */
class OverrideStorage(
    context: Context,
    private val gson: Gson
) {
    private val sharedPreferences =
        context.getSharedPreferences(SHARED_PREF_FEATURE_TOGGLE, Context.MODE_PRIVATE)

    fun getFeatureToggles(): List<FeatureToggleValue>? {
        val json = this.sharedPreferences.getString(FEATURES_KEY, null) ?: return null
        val type = TypeToken.getParameterized(List::class.java, FeatureToggleValue::class.java).type
        return gson.fromJson(json, type)
    }

    private fun setFeatureToggles(
        toggles: List<FeatureToggleValue>?
    ) {
        sharedPreferences.edit(commit = true) {
            putString(FEATURES_KEY, gson.toJson(toggles))
        }
    }

    private fun setFeatureToggle(featureToggleValue: FeatureToggleValue) {
        val featureToggles = getFeatureToggles()?.toMutableList() ?: mutableListOf()
        featureToggles.removeAll { it.path == featureToggleValue.path }
        featureToggles.add(featureToggleValue)
        setFeatureToggles(featureToggles)
    }

    suspend fun clear() = withContext(Dispatchers.IO) {
        sharedPreferences.edit(commit = true) {
            remove(FEATURES_KEY)
        }
    }

    fun setFeatureToggleValue(toggle: FeatureToggle, value: Boolean) {
        val featureToggleValue = FeatureToggleValue(
            path = toggle.path,
            booleanValue = value,
            source = Source.DEVELOP
        )
        setFeatureToggle(featureToggleValue)
    }

    companion object {
        private const val SHARED_PREF_FEATURE_TOGGLE = "develop_toggles"
        private const val FEATURES_KEY = "features_key"
    }
}
