/*
 * Copyright © 2020 Tinkoff Bank
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

package ru.tinkoff.acquiring.sdk.ui.activities

import android.app.Activity
import android.content.Intent
import android.os.Bundle
import androidx.appcompat.app.AppCompatActivity
import ru.tinkoff.acquiring.sdk.R
import ru.tinkoff.acquiring.sdk.redesign.common.LauncherConstants
import ru.tinkoff.acquiring.sdk.utils.getOptions

internal class QrCodeActivity : AppCompatActivity() {

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)

        setContentView(R.layout.acq_qrcode_activity)

        val qrCodeFragment = QrCodeFlowFragment.newInstance(intent.getOptions())

        QrCodeFlowFragment.registerResultListener(supportFragmentManager, this) {
            when (it) {
                QrCodeFlowFragment.Result.Cancel -> {
                    setResult(Activity.RESULT_CANCELED)
                    finish()
                }

                is QrCodeFlowFragment.Result.Failed -> {
                    setResult(
                        LauncherConstants.RESULT_ERROR,
                        Intent()
                            .putExtra(LauncherConstants.EXTRA_ERROR, it.error)
                            .putExtra(LauncherConstants.EXTRA_PAYMENT_ID, it.paymentId)
                    )
                    finish()
                }

                is QrCodeFlowFragment.Result.Success -> {
                    setResult(Activity.RESULT_OK)
                    finish()
                }
            }
        }

        supportFragmentManager.beginTransaction()
            .replace(R.id.acq_ll_root, qrCodeFragment)
            .commit()
    }
}
