package ru.tinkoff.acquiring.sdk.ui.activities

import android.os.Parcelable
import kotlinx.parcelize.Parcelize
import ru.tinkoff.acquiring.sdk.models.result.AsdkResult
import ru.tinkoff.acquiring.sdk.threeds.ThreeDsDataSDK

sealed interface ThreeDsResult : Parcelable {

    @Parcelize
    data class Success(
        val result: AsdkResult
    ) : ThreeDsResult

    @Parcelize
    data class Error(
        val error: Throwable,
        val paymentId: Long? = null,
    ) : ThreeDsResult

    @Parcelize
    data object Cancel : ThreeDsResult
}
