package ru.tinkoff.acquiring.sdk.ui.customview

import android.content.Context
import android.util.AttributeSet
import android.view.MotionEvent
import androidx.coordinatorlayout.widget.CoordinatorLayout

/**
 * @author s.y.biryukov
 */
class LockableCoordinatorLayout @JvmOverloads constructor(
    context: Context, attrs: AttributeSet? = null
) : CoordinatorLayout(context, attrs), LockableView {
    override var isLocked: Boolean = false

    override fun onInterceptTouchEvent(ev: MotionEvent?): Boolean {
        return isLocked || super.onInterceptTouchEvent(ev)
    }
}


interface LockableView {
    var isLocked: Boolean
    fun lockView() {
        isLocked = true
    }

    fun unlockView() {
        isLocked = false
    }
}
