package ru.tinkoff.acquiring.sdk.ui.customview.status

import android.content.Context
import android.util.AttributeSet
import android.view.LayoutInflater
import android.widget.FrameLayout
import androidx.annotation.AttrRes
import androidx.annotation.DrawableRes
import androidx.core.view.isInvisible
import androidx.core.view.isVisible
import ru.tinkoff.acquiring.sdk.R
import ru.tinkoff.acquiring.sdk.databinding.AcqStatusViewBinding

/**
 * @author s.y.biryukov
 */
class StatusView @JvmOverloads constructor(
    context: Context,
    attrs: AttributeSet? = null,
    @AttrRes defStyleAttr: Int = 0
) : FrameLayout(context, attrs, defStyleAttr) {
    private var binding: AcqStatusViewBinding =
        AcqStatusViewBinding.inflate(LayoutInflater.from(context), this, true)

    var title: String? = null
        set(value) {
            field = value
            binding.title.apply {
                isVisible = value.isNullOrBlank().not()
                text = value
            }
        }

    var description: String? = null
        set(value) {
            field = value
            binding.description.apply {
                isVisible = value.isNullOrBlank().not()
                text = value
            }
        }

    @DrawableRes
    var icon: Int? = null
        set(value) {
            field = value
            binding.icon.apply {
                if (value == null) {
                    setImageDrawable(null)
                    isInvisible = true
                } else {
                    setImageResource(value)
                    isVisible = true
                }
            }
        }

    var amount: String? = null
        set(value) {
            field = value
            binding.amount.apply {
                if (amount.isNullOrBlank()) {
                    isVisible = false
                } else {
                    isVisible = true
                    text = value
                }
            }
        }

    var buttonText: String? = null
        set(value) {
            field = value
            binding.button.apply {
                if (value.isNullOrBlank()) {
                    isVisible = false
                } else {
                    isVisible = true
                    text = value
                }
            }
        }

    var onButtonClick: (() -> Unit)? = null
        set(value) {
            field = value
            binding.button.apply {
                if (value == null) {
                    setOnClickListener(null)
                } else {
                    setOnClickListener { value() }
                }
            }
        }

    fun fill(data: StatusViewData) {
        icon = data.type.icon
        title = data.title
        description = data.description
        amount = data.amount
        buttonText = data.buttonText
        onButtonClick = data.onButtonClick
    }
}

data class StatusViewData(
    val type: Type = Type.PROGRESS,
    val title: String? = null,
    val description: String? = null,
    val amount: String? = null,
    val buttonText: String? = null,
) {
    var onButtonClick: (() -> Unit)? = null
    var onCloseByUser: (() -> Unit)? = null

    constructor(
        type: Type = Type.PROGRESS,
        title: String? = null,
        description: String? = null,
        amount: String? = null,
        buttonText: String? = null,
        onButtonClick: (() -> Unit)? = null,
        onCloseByUser: (() -> Unit)? = null
    ) : this(type ,title, description, amount, buttonText)  {
        this.onButtonClick = onButtonClick
        this.onCloseByUser = onCloseByUser
    }

    enum class Type(@DrawableRes val icon: Int? = null) {
        SUCCESS(R.drawable.acq_chat_check),
        ERROR(R.drawable.acq_error_red),
        PROGRESS(R.drawable.acq_stopwach),
        PAYMENT_TIMEOUT(R.drawable.acq_sandclock),
        ALARM(R.drawable.acq_alarm),
        OFFLINE(R.drawable.acq_wi_fi_off),
        CARDS_EMPTY(R.drawable.acq_ic_cards_list_empty),
    }
}

